// $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/verunilibs/data/rainier/FIFO36_72_EXP.v,v 1.13 2007/06/15 20:58:41 wloo Exp $
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2005 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 10.1
//  \   \         Description : Xilinx Functional Simulation Library Component
//  /   /                  36K-Bit FIFO
// /___/   /\     Filename : FIFO36_72_EXP.v
// \   \  /  \    Timestamp : Tues July 26 16:44:06 PST 2005
//  \___\/\___\
//
// Revision:
//    07/26/05 - Initial version.
//    06/14/07 - Implemented high performace version of the model.
// End Revision

`timescale 1 ps/1 ps

module FIFO36_72_EXP (ALMOSTEMPTY, ALMOSTFULL, DBITERR, DO, DOP, ECCPARITY, EMPTY, FULL, RDCOUNT, RDERR, SBITERR, WRCOUNT, WRERR,
		      DI, DIP, RDCLKL, RDCLKU, RDEN, RDRCLKL, RDRCLKU, RST, WRCLKL, WRCLKU, WREN);

    parameter ALMOST_EMPTY_OFFSET = 9'h080;
    parameter ALMOST_FULL_OFFSET = 9'h080;
    parameter integer DO_REG = 1;
    parameter EN_ECC_WRITE = "FALSE";
    parameter EN_ECC_READ = "FALSE";
    parameter EN_SYN = "FALSE";
    parameter FIRST_WORD_FALL_THROUGH = "FALSE";
    parameter SIM_MODE = "SAFE";
    
    output ALMOSTEMPTY;
    output ALMOSTFULL;
    output DBITERR;
    output [63:0] DO;
    output [7:0] DOP;
    output [7:0] ECCPARITY;
    output EMPTY;
    output FULL;
    output [12:0] RDCOUNT;
    output RDERR;
    output SBITERR;
    output [12:0] WRCOUNT;
    output WRERR;

    input [63:0] DI;
    input [7:0] DIP;
    input RDCLKL;
    input RDCLKU;
    input RDEN;
    input RDRCLKL;
    input RDRCLKU;
    input RST;
    input WRCLKL;
    input WRCLKU;
    input WREN;
    
    tri0 GSR = glbl.GSR;
    
    AFIFO36_INTERNAL INT_FIFO (.ALMOSTEMPTY(ALMOSTEMPTY), .ALMOSTFULL(ALMOSTFULL), .DBITERR(DBITERR), .DO(DO), .DOP(DOP), .ECCPARITY(ECCPARITY), .EMPTY(EMPTY), .FULL(FULL), .RDCOUNT(RDCOUNT), .RDERR(RDERR), .SBITERR(SBITERR), .WRCOUNT(WRCOUNT), .WRERR(WRERR), .DI(DI), .DIP(DIP), .RDCLK(RDCLKL), .RDEN(RDEN), .RDRCLK(RDRCLKL), .RST(RST), .WRCLK(WRCLKL), .WREN(WREN));

    defparam INT_FIFO.ALMOST_EMPTY_OFFSET = ALMOST_EMPTY_OFFSET;
    defparam INT_FIFO.ALMOST_FULL_OFFSET = ALMOST_FULL_OFFSET;
    defparam INT_FIFO.DATA_WIDTH = 72;
    defparam INT_FIFO.DO_REG = DO_REG;
    defparam INT_FIFO.EN_ECC_WRITE = EN_ECC_WRITE;
    defparam INT_FIFO.EN_ECC_READ = EN_ECC_READ;
    defparam INT_FIFO.EN_SYN = EN_SYN;
    defparam INT_FIFO.FIRST_WORD_FALL_THROUGH = FIRST_WORD_FALL_THROUGH;
    defparam INT_FIFO.SIM_MODE = SIM_MODE;
    
    specify

        (RDCLKL => DO[0]) = (100, 100);
        (RDCLKL => DO[1]) = (100, 100);
        (RDCLKL => DO[2]) = (100, 100);
        (RDCLKL => DO[3]) = (100, 100);
        (RDCLKL => DO[4]) = (100, 100);
        (RDCLKL => DO[5]) = (100, 100);
        (RDCLKL => DO[6]) = (100, 100);
        (RDCLKL => DO[7]) = (100, 100);
        (RDCLKL => DO[8]) = (100, 100);
        (RDCLKL => DO[9]) = (100, 100);
        (RDCLKL => DO[10]) = (100, 100);
        (RDCLKL => DO[11]) = (100, 100);
        (RDCLKL => DO[12]) = (100, 100);
        (RDCLKL => DO[13]) = (100, 100);
        (RDCLKL => DO[14]) = (100, 100);
        (RDCLKL => DO[15]) = (100, 100);
        (RDCLKL => DO[16]) = (100, 100);
        (RDCLKL => DO[17]) = (100, 100);
        (RDCLKL => DO[18]) = (100, 100);
        (RDCLKL => DO[19]) = (100, 100);
        (RDCLKL => DO[20]) = (100, 100);
        (RDCLKL => DO[21]) = (100, 100);
        (RDCLKL => DO[22]) = (100, 100);
        (RDCLKL => DO[23]) = (100, 100);
        (RDCLKL => DO[24]) = (100, 100);
        (RDCLKL => DO[25]) = (100, 100);
        (RDCLKL => DO[26]) = (100, 100);
        (RDCLKL => DO[27]) = (100, 100);
        (RDCLKL => DO[28]) = (100, 100);
        (RDCLKL => DO[29]) = (100, 100);
        (RDCLKL => DO[30]) = (100, 100);
        (RDCLKL => DO[31]) = (100, 100);
        (RDCLKL => DO[32]) = (100, 100);
        (RDCLKL => DO[33]) = (100, 100);
        (RDCLKL => DO[34]) = (100, 100);
        (RDCLKL => DO[35]) = (100, 100);
        (RDCLKL => DO[36]) = (100, 100);
        (RDCLKL => DO[37]) = (100, 100);
        (RDCLKL => DO[38]) = (100, 100);
        (RDCLKL => DO[39]) = (100, 100);
        (RDCLKL => DO[40]) = (100, 100);
	(RDCLKL => DO[41]) = (100, 100);
        (RDCLKL => DO[42]) = (100, 100);
        (RDCLKL => DO[43]) = (100, 100);
        (RDCLKL => DO[44]) = (100, 100);
        (RDCLKL => DO[45]) = (100, 100);
        (RDCLKL => DO[46]) = (100, 100);
        (RDCLKL => DO[47]) = (100, 100);
        (RDCLKL => DO[48]) = (100, 100);
        (RDCLKL => DO[49]) = (100, 100);
        (RDCLKL => DO[50]) = (100, 100);
	(RDCLKL => DO[51]) = (100, 100);
        (RDCLKL => DO[52]) = (100, 100);
        (RDCLKL => DO[53]) = (100, 100);
        (RDCLKL => DO[54]) = (100, 100);
        (RDCLKL => DO[55]) = (100, 100);
        (RDCLKL => DO[56]) = (100, 100);
        (RDCLKL => DO[57]) = (100, 100);
        (RDCLKL => DO[58]) = (100, 100);
        (RDCLKL => DO[59]) = (100, 100);
        (RDCLKL => DO[60]) = (100, 100);
	(RDCLKL => DO[61]) = (100, 100);
        (RDCLKL => DO[62]) = (100, 100);
        (RDCLKL => DO[63]) = (100, 100);
        (RDCLKL => DOP[0]) = (100, 100);
        (RDCLKL => DOP[1]) = (100, 100);
        (RDCLKL => DOP[2]) = (100, 100);
        (RDCLKL => DOP[3]) = (100, 100);
        (RDCLKL => DOP[4]) = (100, 100);
        (RDCLKL => DOP[5]) = (100, 100);
        (RDCLKL => DOP[6]) = (100, 100);
        (RDCLKL => DOP[7]) = (100, 100);
	(RDCLKL => DBITERR) = (100, 100);
	(RDCLKL => SBITERR) = (100, 100);
        (RDRCLKL => DO[0]) = (100, 100);
        (RDRCLKL => DO[1]) = (100, 100);
        (RDRCLKL => DO[2]) = (100, 100);
        (RDRCLKL => DO[3]) = (100, 100);
        (RDRCLKL => DO[4]) = (100, 100);
        (RDRCLKL => DO[5]) = (100, 100);
        (RDRCLKL => DO[6]) = (100, 100);
        (RDRCLKL => DO[7]) = (100, 100);
        (RDRCLKL => DO[8]) = (100, 100);
        (RDRCLKL => DO[9]) = (100, 100);
        (RDRCLKL => DO[10]) = (100, 100);
        (RDRCLKL => DO[11]) = (100, 100);
        (RDRCLKL => DO[12]) = (100, 100);
        (RDRCLKL => DO[13]) = (100, 100);
        (RDRCLKL => DO[14]) = (100, 100);
        (RDRCLKL => DO[15]) = (100, 100);
        (RDRCLKL => DO[16]) = (100, 100);
        (RDRCLKL => DO[17]) = (100, 100);
        (RDRCLKL => DO[18]) = (100, 100);
        (RDRCLKL => DO[19]) = (100, 100);
        (RDRCLKL => DO[20]) = (100, 100);
        (RDRCLKL => DO[21]) = (100, 100);
        (RDRCLKL => DO[22]) = (100, 100);
        (RDRCLKL => DO[23]) = (100, 100);
        (RDRCLKL => DO[24]) = (100, 100);
        (RDRCLKL => DO[25]) = (100, 100);
        (RDRCLKL => DO[26]) = (100, 100);
        (RDRCLKL => DO[27]) = (100, 100);
        (RDRCLKL => DO[28]) = (100, 100);
        (RDRCLKL => DO[29]) = (100, 100);
        (RDRCLKL => DO[30]) = (100, 100);
        (RDRCLKL => DO[31]) = (100, 100);
        (RDRCLKL => DO[32]) = (100, 100);
        (RDRCLKL => DO[33]) = (100, 100);
        (RDRCLKL => DO[34]) = (100, 100);
        (RDRCLKL => DO[35]) = (100, 100);
        (RDRCLKL => DO[36]) = (100, 100);
        (RDRCLKL => DO[37]) = (100, 100);
        (RDRCLKL => DO[38]) = (100, 100);
        (RDRCLKL => DO[39]) = (100, 100);
        (RDRCLKL => DO[40]) = (100, 100);
	(RDRCLKL => DO[41]) = (100, 100);
        (RDRCLKL => DO[42]) = (100, 100);
        (RDRCLKL => DO[43]) = (100, 100);
        (RDRCLKL => DO[44]) = (100, 100);
        (RDRCLKL => DO[45]) = (100, 100);
        (RDRCLKL => DO[46]) = (100, 100);
        (RDRCLKL => DO[47]) = (100, 100);
        (RDRCLKL => DO[48]) = (100, 100);
        (RDRCLKL => DO[49]) = (100, 100);
        (RDRCLKL => DO[50]) = (100, 100);
	(RDRCLKL => DO[51]) = (100, 100);
        (RDRCLKL => DO[52]) = (100, 100);
        (RDRCLKL => DO[53]) = (100, 100);
        (RDRCLKL => DO[54]) = (100, 100);
        (RDRCLKL => DO[55]) = (100, 100);
        (RDRCLKL => DO[56]) = (100, 100);
        (RDRCLKL => DO[57]) = (100, 100);
        (RDRCLKL => DO[58]) = (100, 100);
        (RDRCLKL => DO[59]) = (100, 100);
        (RDRCLKL => DO[60]) = (100, 100);
	(RDRCLKL => DO[61]) = (100, 100);
        (RDRCLKL => DO[62]) = (100, 100);
        (RDRCLKL => DO[63]) = (100, 100);
        (RDRCLKL => DOP[0]) = (100, 100);
        (RDRCLKL => DOP[1]) = (100, 100);
        (RDRCLKL => DOP[2]) = (100, 100);
        (RDRCLKL => DOP[3]) = (100, 100);
        (RDRCLKL => DOP[4]) = (100, 100);
        (RDRCLKL => DOP[5]) = (100, 100);
        (RDRCLKL => DOP[6]) = (100, 100);
        (RDRCLKL => DOP[7]) = (100, 100);
	(RDRCLKL => DBITERR) = (100, 100);
	(RDRCLKL => SBITERR) = (100, 100);
        (WRCLKL => ECCPARITY[0]) = (100, 100);
        (WRCLKL => ECCPARITY[1]) = (100, 100);
        (WRCLKL => ECCPARITY[2]) = (100, 100);
        (WRCLKL => ECCPARITY[3]) = (100, 100);
        (WRCLKL => ECCPARITY[4]) = (100, 100);
        (WRCLKL => ECCPARITY[5]) = (100, 100);
        (WRCLKL => ECCPARITY[6]) = (100, 100);
        (WRCLKL => ECCPARITY[7]) = (100, 100);

	(RDCLKL => ALMOSTEMPTY) = (100, 100);
	(RDCLKL => EMPTY) = (100, 100);
	(RDCLKL => RDCOUNT[0]) = (100, 100);
	(RDCLKL => RDCOUNT[10]) = (100, 100);
	(RDCLKL => RDCOUNT[11]) = (100, 100);
	(RDCLKL => RDCOUNT[12]) = (100, 100);
	(RDCLKL => RDCOUNT[1]) = (100, 100);
	(RDCLKL => RDCOUNT[2]) = (100, 100);
	(RDCLKL => RDCOUNT[3]) = (100, 100);
	(RDCLKL => RDCOUNT[4]) = (100, 100);
	(RDCLKL => RDCOUNT[5]) = (100, 100);
	(RDCLKL => RDCOUNT[6]) = (100, 100);
	(RDCLKL => RDCOUNT[7]) = (100, 100);
	(RDCLKL => RDCOUNT[8]) = (100, 100);
	(RDCLKL => RDCOUNT[9]) = (100, 100);
	(RDCLKL => RDERR) = (100, 100);

	(RDRCLKL => ALMOSTEMPTY) = (100, 100);
	(RDRCLKL => EMPTY) = (100, 100);
	(RDRCLKL => RDCOUNT[0]) = (100, 100);
	(RDRCLKL => RDCOUNT[10]) = (100, 100);
	(RDRCLKL => RDCOUNT[11]) = (100, 100);
	(RDRCLKL => RDCOUNT[12]) = (100, 100);
	(RDRCLKL => RDCOUNT[1]) = (100, 100);
	(RDRCLKL => RDCOUNT[2]) = (100, 100);
	(RDRCLKL => RDCOUNT[3]) = (100, 100);
	(RDRCLKL => RDCOUNT[4]) = (100, 100);
	(RDRCLKL => RDCOUNT[5]) = (100, 100);
	(RDRCLKL => RDCOUNT[6]) = (100, 100);
	(RDRCLKL => RDCOUNT[7]) = (100, 100);
	(RDRCLKL => RDCOUNT[8]) = (100, 100);
	(RDRCLKL => RDCOUNT[9]) = (100, 100);
	(RDRCLKL => RDERR) = (100, 100);

	(WRCLKL => ALMOSTFULL) = (100, 100);
	(WRCLKL => FULL) = (100, 100);
	(WRCLKL => WRCOUNT[0]) = (100, 100);
	(WRCLKL => WRCOUNT[10]) = (100, 100);
	(WRCLKL => WRCOUNT[11]) = (100, 100);
	(WRCLKL => WRCOUNT[12]) = (100, 100);
	(WRCLKL => WRCOUNT[1]) = (100, 100);
	(WRCLKL => WRCOUNT[2]) = (100, 100);
	(WRCLKL => WRCOUNT[3]) = (100, 100);
	(WRCLKL => WRCOUNT[4]) = (100, 100);
	(WRCLKL => WRCOUNT[5]) = (100, 100);
	(WRCLKL => WRCOUNT[6]) = (100, 100);
	(WRCLKL => WRCOUNT[7]) = (100, 100);
	(WRCLKL => WRCOUNT[8]) = (100, 100);
	(WRCLKL => WRCOUNT[9]) = (100, 100);
	(WRCLKL => WRERR) = (100, 100);

        (RDCLKU => DO[0]) = (100, 100);
        (RDCLKU => DO[1]) = (100, 100);
        (RDCLKU => DO[2]) = (100, 100);
        (RDCLKU => DO[3]) = (100, 100);
        (RDCLKU => DO[4]) = (100, 100);
        (RDCLKU => DO[5]) = (100, 100);
        (RDCLKU => DO[6]) = (100, 100);
        (RDCLKU => DO[7]) = (100, 100);
        (RDCLKU => DO[8]) = (100, 100);
        (RDCLKU => DO[9]) = (100, 100);
        (RDCLKU => DO[10]) = (100, 100);
        (RDCLKU => DO[11]) = (100, 100);
        (RDCLKU => DO[12]) = (100, 100);
        (RDCLKU => DO[13]) = (100, 100);
        (RDCLKU => DO[14]) = (100, 100);
        (RDCLKU => DO[15]) = (100, 100);
        (RDCLKU => DO[16]) = (100, 100);
        (RDCLKU => DO[17]) = (100, 100);
        (RDCLKU => DO[18]) = (100, 100);
        (RDCLKU => DO[19]) = (100, 100);
        (RDCLKU => DO[20]) = (100, 100);
        (RDCLKU => DO[21]) = (100, 100);
        (RDCLKU => DO[22]) = (100, 100);
        (RDCLKU => DO[23]) = (100, 100);
        (RDCLKU => DO[24]) = (100, 100);
        (RDCLKU => DO[25]) = (100, 100);
        (RDCLKU => DO[26]) = (100, 100);
        (RDCLKU => DO[27]) = (100, 100);
        (RDCLKU => DO[28]) = (100, 100);
        (RDCLKU => DO[29]) = (100, 100);
        (RDCLKU => DO[30]) = (100, 100);
        (RDCLKU => DO[31]) = (100, 100);
        (RDCLKU => DO[32]) = (100, 100);
        (RDCLKU => DO[33]) = (100, 100);
        (RDCLKU => DO[34]) = (100, 100);
        (RDCLKU => DO[35]) = (100, 100);
        (RDCLKU => DO[36]) = (100, 100);
        (RDCLKU => DO[37]) = (100, 100);
        (RDCLKU => DO[38]) = (100, 100);
        (RDCLKU => DO[39]) = (100, 100);
        (RDCLKU => DO[40]) = (100, 100);
	(RDCLKU => DO[41]) = (100, 100);
        (RDCLKU => DO[42]) = (100, 100);
        (RDCLKU => DO[43]) = (100, 100);
        (RDCLKU => DO[44]) = (100, 100);
        (RDCLKU => DO[45]) = (100, 100);
        (RDCLKU => DO[46]) = (100, 100);
        (RDCLKU => DO[47]) = (100, 100);
        (RDCLKU => DO[48]) = (100, 100);
        (RDCLKU => DO[49]) = (100, 100);
        (RDCLKU => DO[50]) = (100, 100);
	(RDCLKU => DO[51]) = (100, 100);
        (RDCLKU => DO[52]) = (100, 100);
        (RDCLKU => DO[53]) = (100, 100);
        (RDCLKU => DO[54]) = (100, 100);
        (RDCLKU => DO[55]) = (100, 100);
        (RDCLKU => DO[56]) = (100, 100);
        (RDCLKU => DO[57]) = (100, 100);
        (RDCLKU => DO[58]) = (100, 100);
        (RDCLKU => DO[59]) = (100, 100);
        (RDCLKU => DO[60]) = (100, 100);
	(RDCLKU => DO[61]) = (100, 100);
        (RDCLKU => DO[62]) = (100, 100);
        (RDCLKU => DO[63]) = (100, 100);
        (RDCLKU => DOP[0]) = (100, 100);
        (RDCLKU => DOP[1]) = (100, 100);
        (RDCLKU => DOP[2]) = (100, 100);
        (RDCLKU => DOP[3]) = (100, 100);
        (RDCLKU => DOP[4]) = (100, 100);
        (RDCLKU => DOP[5]) = (100, 100);
        (RDCLKU => DOP[6]) = (100, 100);
        (RDCLKU => DOP[7]) = (100, 100);
	(RDCLKU => DBITERR) = (100, 100);
	(RDCLKU => SBITERR) = (100, 100);
        (RDRCLKU => DO[0]) = (100, 100);
        (RDRCLKU => DO[1]) = (100, 100);
        (RDRCLKU => DO[2]) = (100, 100);
        (RDRCLKU => DO[3]) = (100, 100);
        (RDRCLKU => DO[4]) = (100, 100);
        (RDRCLKU => DO[5]) = (100, 100);
        (RDRCLKU => DO[6]) = (100, 100);
        (RDRCLKU => DO[7]) = (100, 100);
        (RDRCLKU => DO[8]) = (100, 100);
        (RDRCLKU => DO[9]) = (100, 100);
        (RDRCLKU => DO[10]) = (100, 100);
        (RDRCLKU => DO[11]) = (100, 100);
        (RDRCLKU => DO[12]) = (100, 100);
        (RDRCLKU => DO[13]) = (100, 100);
        (RDRCLKU => DO[14]) = (100, 100);
        (RDRCLKU => DO[15]) = (100, 100);
        (RDRCLKU => DO[16]) = (100, 100);
        (RDRCLKU => DO[17]) = (100, 100);
        (RDRCLKU => DO[18]) = (100, 100);
        (RDRCLKU => DO[19]) = (100, 100);
        (RDRCLKU => DO[20]) = (100, 100);
        (RDRCLKU => DO[21]) = (100, 100);
        (RDRCLKU => DO[22]) = (100, 100);
        (RDRCLKU => DO[23]) = (100, 100);
        (RDRCLKU => DO[24]) = (100, 100);
        (RDRCLKU => DO[25]) = (100, 100);
        (RDRCLKU => DO[26]) = (100, 100);
        (RDRCLKU => DO[27]) = (100, 100);
        (RDRCLKU => DO[28]) = (100, 100);
        (RDRCLKU => DO[29]) = (100, 100);
        (RDRCLKU => DO[30]) = (100, 100);
        (RDRCLKU => DO[31]) = (100, 100);
        (RDRCLKU => DO[32]) = (100, 100);
        (RDRCLKU => DO[33]) = (100, 100);
        (RDRCLKU => DO[34]) = (100, 100);
        (RDRCLKU => DO[35]) = (100, 100);
        (RDRCLKU => DO[36]) = (100, 100);
        (RDRCLKU => DO[37]) = (100, 100);
        (RDRCLKU => DO[38]) = (100, 100);
        (RDRCLKU => DO[39]) = (100, 100);
        (RDRCLKU => DO[40]) = (100, 100);
	(RDRCLKU => DO[41]) = (100, 100);
        (RDRCLKU => DO[42]) = (100, 100);
        (RDRCLKU => DO[43]) = (100, 100);
        (RDRCLKU => DO[44]) = (100, 100);
        (RDRCLKU => DO[45]) = (100, 100);
        (RDRCLKU => DO[46]) = (100, 100);
        (RDRCLKU => DO[47]) = (100, 100);
        (RDRCLKU => DO[48]) = (100, 100);
        (RDRCLKU => DO[49]) = (100, 100);
        (RDRCLKU => DO[50]) = (100, 100);
	(RDRCLKU => DO[51]) = (100, 100);
        (RDRCLKU => DO[52]) = (100, 100);
        (RDRCLKU => DO[53]) = (100, 100);
        (RDRCLKU => DO[54]) = (100, 100);
        (RDRCLKU => DO[55]) = (100, 100);
        (RDRCLKU => DO[56]) = (100, 100);
        (RDRCLKU => DO[57]) = (100, 100);
        (RDRCLKU => DO[58]) = (100, 100);
        (RDRCLKU => DO[59]) = (100, 100);
        (RDRCLKU => DO[60]) = (100, 100);
	(RDRCLKU => DO[61]) = (100, 100);
        (RDRCLKU => DO[62]) = (100, 100);
        (RDRCLKU => DO[63]) = (100, 100);
        (RDRCLKU => DOP[0]) = (100, 100);
        (RDRCLKU => DOP[1]) = (100, 100);
        (RDRCLKU => DOP[2]) = (100, 100);
        (RDRCLKU => DOP[3]) = (100, 100);
        (RDRCLKU => DOP[4]) = (100, 100);
        (RDRCLKU => DOP[5]) = (100, 100);
        (RDRCLKU => DOP[6]) = (100, 100);
        (RDRCLKU => DOP[7]) = (100, 100);
	(RDRCLKU => DBITERR) = (100, 100);
	(RDRCLKU => SBITERR) = (100, 100);
        (WRCLKU => ECCPARITY[0]) = (100, 100);
        (WRCLKU => ECCPARITY[1]) = (100, 100);
        (WRCLKU => ECCPARITY[2]) = (100, 100);
        (WRCLKU => ECCPARITY[3]) = (100, 100);
        (WRCLKU => ECCPARITY[4]) = (100, 100);
        (WRCLKU => ECCPARITY[5]) = (100, 100);
        (WRCLKU => ECCPARITY[6]) = (100, 100);
        (WRCLKU => ECCPARITY[7]) = (100, 100);

	(RDCLKU => ALMOSTEMPTY) = (100, 100);
	(RDCLKU => EMPTY) = (100, 100);
	(RDCLKU => RDCOUNT[0]) = (100, 100);
	(RDCLKU => RDCOUNT[10]) = (100, 100);
	(RDCLKU => RDCOUNT[11]) = (100, 100);
	(RDCLKU => RDCOUNT[12]) = (100, 100);
	(RDCLKU => RDCOUNT[1]) = (100, 100);
	(RDCLKU => RDCOUNT[2]) = (100, 100);
	(RDCLKU => RDCOUNT[3]) = (100, 100);
	(RDCLKU => RDCOUNT[4]) = (100, 100);
	(RDCLKU => RDCOUNT[5]) = (100, 100);
	(RDCLKU => RDCOUNT[6]) = (100, 100);
	(RDCLKU => RDCOUNT[7]) = (100, 100);
	(RDCLKU => RDCOUNT[8]) = (100, 100);
	(RDCLKU => RDCOUNT[9]) = (100, 100);
	(RDCLKU => RDERR) = (100, 100);

	(RDRCLKU => ALMOSTEMPTY) = (100, 100);
	(RDRCLKU => EMPTY) = (100, 100);
	(RDRCLKU => RDCOUNT[0]) = (100, 100);
	(RDRCLKU => RDCOUNT[10]) = (100, 100);
	(RDRCLKU => RDCOUNT[11]) = (100, 100);
	(RDRCLKU => RDCOUNT[12]) = (100, 100);
	(RDRCLKU => RDCOUNT[1]) = (100, 100);
	(RDRCLKU => RDCOUNT[2]) = (100, 100);
	(RDRCLKU => RDCOUNT[3]) = (100, 100);
	(RDRCLKU => RDCOUNT[4]) = (100, 100);
	(RDRCLKU => RDCOUNT[5]) = (100, 100);
	(RDRCLKU => RDCOUNT[6]) = (100, 100);
	(RDRCLKU => RDCOUNT[7]) = (100, 100);
	(RDRCLKU => RDCOUNT[8]) = (100, 100);
	(RDRCLKU => RDCOUNT[9]) = (100, 100);
	(RDRCLKU => RDERR) = (100, 100);

	(WRCLKU => ALMOSTFULL) = (100, 100);
	(WRCLKU => FULL) = (100, 100);
	(WRCLKU => WRCOUNT[0]) = (100, 100);
	(WRCLKU => WRCOUNT[10]) = (100, 100);
	(WRCLKU => WRCOUNT[11]) = (100, 100);
	(WRCLKU => WRCOUNT[12]) = (100, 100);
	(WRCLKU => WRCOUNT[1]) = (100, 100);
	(WRCLKU => WRCOUNT[2]) = (100, 100);
	(WRCLKU => WRCOUNT[3]) = (100, 100);
	(WRCLKU => WRCOUNT[4]) = (100, 100);
	(WRCLKU => WRCOUNT[5]) = (100, 100);
	(WRCLKU => WRCOUNT[6]) = (100, 100);
	(WRCLKU => WRCOUNT[7]) = (100, 100);
	(WRCLKU => WRCOUNT[8]) = (100, 100);
	(WRCLKU => WRCOUNT[9]) = (100, 100);
	(WRCLKU => WRERR) = (100, 100);
	
	specparam PATHPULSE$ = 0;

    endspecify
    
endmodule // FIFO36_72_EXP

